/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.task;

import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.util.LocalizableText;
import java.io.Serializable;

public class ProgressData
implements Serializable {
    public static final int COMPLETED_STATUS_IGNORE = -1;
    public static final int COMPLETED_STATUS_RUNNING = 0;
    public static final int COMPLETED_STATUS_SUCCESS = 1;
    public static final int COMPLETED_STATUS_WARNINGS = 2;
    public static final int COMPLETED_STATUS_FAILED = 3;
    public static final int COMPLETED_STATUS_CANCELED = 4;
    private int completionStatus = -1;
    private LocalizableText name;
    private ObjectId objectId;
    private LocalizableText text = null;
    private long durationTime = 0L;
    private Object details = null;

    public LocalizableText getName() {
        return this.name;
    }

    public void setName(LocalizableText name) {
        this.name = name;
    }

    public ObjectId getObjectId() {
        return this.objectId;
    }

    public void setObjectId(ObjectId objectId) {
        this.objectId = objectId;
    }

    public LocalizableText getText() {
        return this.text;
    }

    public void setText(LocalizableText text) {
        this.text = text;
    }

    public long getDurationTime() {
        return this.durationTime;
    }

    public void setDurationTime(long durationTime) {
        this.durationTime = durationTime;
    }

    public int getCompletionStatus() {
        return this.completionStatus;
    }

    public void setCompletionStatus(int completionStatus) {
        if (completionStatus < -1 || completionStatus > 4) {
            throw new IllegalArgumentException("null id specified");
        }
        this.completionStatus = completionStatus;
    }

    public Object getDetails() {
        return this.details;
    }

    public void setDetails(Object details) {
        this.details = details;
    }

    public String toString() {
        String name;
        String s = this.getClass().getName() + ": ";
        LocalizableText thename = this.getName();
        s = thename == null ? s + "null" : ((name = thename.toString()) == null ? s + "null" : s + name);
        return s;
    }

    public ProgressData(LocalizableText name, ObjectId objectId, LocalizableText text, long durationTime, int completionStatus) {
        this.name = name;
        this.objectId = objectId;
        this.text = text;
        this.durationTime = durationTime;
        this.completionStatus = completionStatus;
    }

    public ProgressData(LocalizableText name, ObjectId objectId, LocalizableText text) {
        this(name, objectId, text, 0L, -1);
    }

    public ProgressData(LocalizableText name, ObjectId objectId, long durationTime) {
        this(name, objectId, null, durationTime, -1);
    }

    public ProgressData(LocalizableText name, ObjectId objectId, int completionStatus) {
        this(name, objectId, null, 0L, completionStatus);
    }

    public ProgressData(LocalizableText name, ObjectId objectId) {
        this(name, objectId, null, 0L, -1);
    }

    public ProgressData(ObjectId objectId) {
        this(null, objectId, null, 0L, -1);
    }

    public ProgressData(LocalizableText text, long durationTime, int completionStatus) {
        this(null, null, text, durationTime, completionStatus);
    }

    public ProgressData(LocalizableText text) {
        this(null, null, text, 0L, -1);
    }

    public ProgressData(long durationTime) {
        this(null, null, null, durationTime, -1);
    }

    public ProgressData(int completionStatus) {
        this(null, null, null, 0L, completionStatus);
    }

    public ProgressData() {
        this(null, null, null, 0L, -1);
    }
}

